; SmartMorph loader
; written by alexander yaworsky
;

.386p

_TEXT        SEGMENT USE32 'CODE'
             ASSUME  CS:_TEXT

INCLUDE  sm.inc

??;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; put resource type and id, original image address loaded image base address
; here before execution of the attached file
;

;
; loader's import table entry
;
ite          MACRO func, module
             DB    0E9h
             DD    0
             icd   <func>, <module>
             ENDM

_wLoaderCodeSize  DD    Code_End - Code_Begin
                  PUBLIC  _wLoaderCodeSize

_wLoaderITOffset  DD   ITBegin - Code_Begin
                  PUBLIC  _wLoaderITOffset

_wLoaderITSize    DD   (ITEnd - ITBegin) / SIZE ite
                  PUBLIC  _wLoaderITSize

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Loader
;

  ALIGN 16

_wLoaderCode LABEL BYTE
             PUBLIC  _wLoaderCode

Code_Begin   LABEL NEAR

             jmp   Loader_Begin

ITBegin      LABEL NEAR
;
; We explicitly define import table. This table must be set
; up each time new exe is being generated and should contain
; relative offsets to IAT entries
;

_imp_ExitProcess:
             ite   'ExitProcess' 'kernel32.dll'
_imp_GetCurrentProcess:
             ite   'GetCurrentProcess' 'kernel32.dll'
_imp_FindResourceA:
             ite   'FindResourceA' 'kernel32.dll'
_imp_LoadResource:
             ite   'LoadResource' 'kernel32.dll'
_imp_SizeofResource:
             ite   'SizeofResource' 'kernel32.dll'
_imp_LocalAlloc:
             ite   'LocalAlloc' 'kernel32.dll'
_imp_LocalFree:
             ite   'LocalFree' 'kernel32.dll'
_imp_VirtualProtectEx:
             ite   'VirtualProtectEx' 'kernel32.dll'
_imp_LoadLibraryA:
             ite   'LoadLibraryA' 'kernel32.dll'
_imp_GetProcAddress:
             ite   'GetProcAddress' 'kernel32.dll'
_imp_GetModuleHandleA:
             ite   'GetModuleHandleA' 'kernel32.dll'
_imp_lstrcmpi:
             ite   'lstrcmpi' 'kernel32.dll'

ITEnd        LABEL NEAR

;
; attached file resource type and id
;
FileResType:
             DD    0
             DD    0         ; FileResId

Loader_Begin:
             call  GetExecutablePtr    ; get pointer to the file contents
             or    EAX,EAX
             jz    SHORT exit
             push  EAX
             call  LoadPEFile          ; load file - returns entry point
             mov   EDX,EAX
             pop   EAX
             call  FreeExecutablePtr   ; free allocated resources
             or    EDX,EDX
             jz    SHORT exit
             jmp   EDX                 ; jump to the entry point of code
exit:
             push  0
             call  _imp_ExitProcess

;
; GetExecutablePtr: get pointer to the file data
; in current implementation the data is taken from resources
; also preserves resource type and id and xor values at the entry point
; IN: none
; OUT: EAX - pointer to the allocated data, zero is returned in case of error
;      ECX - size of data; in case of error it is undefined
;
GetExecutablePtr   PROC
             push  EDX
             push  EBX
             push  ESI
             push  EDI
             push  EBP
             call  NEAR PTR gep_next1
gep_next1:   pop   EDI
             sub   EDI,gep_next1 - FileResType
             push  DWORD PTR [EDI]     ; resource type
             push  DWORD PTR [EDI+4]   ; resource id
             push  0                   ; module handle
             call  _imp_FindResourceA
             or    EAX,EAX             ; found?
             jz    gep_exit            ;    no - exit
             push  EAX                 ; resource handle for SizeofResource
             push  EAX                 ; resource handle
             push  0                   ; module handle
             call  _imp_LoadResource   ; returns pointer
             pop   ECX
             push  EAX                 ; preserve returned pointer
             push  ECX                 ; resource handle
             push  0                   ; module handle
             call  _imp_SizeofResource
             mov   ECX,EAX
             pop   EAX                 ; restore pointer
             or    EAX,EAX
             jz    SHORT gep_exit
             push  EAX                 ; save pointer and size
             push  ECX
             push  ECX                 ; allocate memory
             push  0
             call  _imp_LocalAlloc
             or    EAX,EAX
             pop   ECX                 ; restore size
             pop   ESI                 ; and pointer
             jz    SHORT gep_exit
             push  EAX                 ; preserve return value
             push  ECX
             call  GetEntryPoint
             mov   [EBX],5A5A5A5Ah     ; set signature at the entry point
             mov   EAX,[EDI]           ; preserve resource type and id
             mov   [EBX+4],EAX         ; at the entry point
             mov   EAX,[EDI+4]
             mov   [EBX+8],EAX
             call  NEAR PTR gep_next2  ; set image address at entry point
gep_next2:   pop   EAX                 ; image begins with DWORD (size)
             add   EAX,Code_End - gep_next2
             mov   [EBX+12],EAX        ; image address
             pop   ECX
             pop   EAX
             push  EAX
             push  ECX

             mov   EDI,EAX             ; prepare to move data
             push  EDI
             push  ECX
             cld
             shr   ECX,2               ; file always contains of 512 byte blks
       rep   movsd
             pop   ECX
             pop   EDI

             pop   ECX                 ; restore return values
             pop   EAX
gep_exit:
             pop   EBP
             pop   EDI
             pop   ESI
             pop   EBX
             pop   EDX
             ret
GetExecutablePtr   ENDP

;
; FreeExecutablePtr: free resources allocated by GetExecutablePtr
; in current implementation we free memory
; IN:  EAX - pointer to the allocated data
; OUT: none
;
FreeExecutablePtr  PROC
             pushad
             push  EAX
             call  _imp_LocalFree
             popad
             ret
FreeExecutablePtr  ENDP

;
; LoadPEFile: loads portable executable file into memory and
; returns address of entry point
; also sets loaded image base at the entry point
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - entry point address
;
LoadPEFile   PROC
             push  EDX
             push  ECX
             push  EBX
             push  ESI
             push  EDI
             push  EBP
             mov   EBX,EAX             ; EBX - file data pointer
             call  GetPEheader
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; EDI - PE header offset
             add   EAX,EBX
             call  CheckPEheader       ; check PE header
             jc    lpef_error
             call  CheckOptHeader      ; check optional header and data size
             jc    lpef_error

                   ; now allocate memory for image

             push  EBX
             mov   EAX,[EBX+EDI+20+56] ; size of image
             mov   EBP,[EBX+EDI+20+32] ; alignment
             add   EAX,EBP
             push  EAX
             push  0                   ; LMEM_FIXED
             call  _imp_LocalAlloc
             pop   EBX
             or    EAX,EAX
             jz    lpef_error
             dec   EBP
             add   EAX,EBP             ; align
             not   EBP
             and   EAX,EBP
             mov   EBP,EAX             ; EBP - image

             push  EBX
             call  GetEntryPoint
             mov   [EBX+16],EBP        ; set image address at the entry point
             pop   EBX

                  ; copy sections into image

             movzx ECX,WORD PTR [EBX+EDI+2]     ; number of sections
             lea   EAX,[EBX+EDI+20+224]    ; first section header
             push  EDI
             cld
lpef_load_section:
             push  ECX
             mov   ESI,[EAX+20]        ; source: pointer to raw data
             add   ESI,EBX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination
             shr   ECX,2               ; section data size begins with 512
       rep   movsd                     ; so it will always work right
             pop   ECX
             add   EAX,40
             loop  lpef_load_section
             pop   EDI

                   ; copy file header into image (we need it to get
                   ; attached resources)

             push  EDI
             mov   ECX,[EBX+EDI+20+60] ; size of headers
             mov   EDI,EBP
             mov   ESI,EBX
       rep   movsb
             pop   EDI

             add   EDI,EBX             ; now we don't need separate pointer
                                       ;   and offset, EDI - ptr to PE header

                   ; apply relocation data

             mov   EDX,[EDI+20+28]     ; image base
             sub   EDX,EBP             ; EDX - relocation value
             mov   ESI,[EDI+20+96+40]  ; base relocation data address
             add   ESI,EBP
             mov   ECX,[EDI+20+96+44]  ; base relocation data size
             push  EDI
lpef_next_reloc_block:
             mov   EBX,[ESI]           ; virtual address
             add   EBX,EBP
             mov   EDI,[ESI+4]         ; size
             sub   EDI,8               ;  discard header and use as counter
             push  ESI
             add   ESI,8
lpef_next_relocation:
             movzx EAX,WORD PTR [ESI]
             or    EAX,EAX
             jz    SHORT lpef_cnt1
             and   AH,0Fh              ; !!! ignore type
             sub   [EBX+EAX],EDX
             inc   ESI
             inc   ESI
             sub   EDI,2
             ja    lpef_next_relocation
lpef_cnt1:
             pop   ESI
             mov   EAX,[ESI+4]         ; size of block
             add   ESI,EAX
             sub   ECX,EAX
             jg    lpef_next_reloc_block
             pop   EDI

                   ; resolve imports

             push  EDI
             mov   ESI,[EDI+20+96+8]   ; import directory address
             add   ESI,EBP
lpef_next_module:
             mov   EAX,[ESI+12]        ; module name address
             or    EAX,EAX
             jz    SHORT lpef_end_of_imports
             add   EAX,EBP
             call  CheckWinSock        ; check for wsock and handle separately
             jnc   SHORT lpef_handle_module
             add   ESI,20
             jmp   lpef_next_module
lpef_handle_module:
             push  EAX
             call  _imp_LoadLibraryA
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; preserve module handle in EDI
             push  ESI
             mov   EBX,[ESI]           ; function name list
             add   EBX,EBP
             mov   ESI,[ESI+16]        ; function address list
             add   ESI,EBP
lpef_next_function:
             mov   EAX,[EBX]
             or    EAX,EAX
             jz    SHORT lpef_end_of_functions
             test  EAX,80000000h
             jz    SHORT lpef_by_name
             and   EAX,7FFFFFFFh
             jmp   SHORT lpef_get_proc_addr
lpef_by_name:
             add   EAX,EBP
             inc   EAX
             inc   EAX
lpef_get_proc_addr:
             push  EBX
             push  EAX
             push  EDI
             call  _imp_GetProcAddress
             pop   EBX
             or    EAX,EAX
             jnz   SHORT lpef_cnt2
             pop   ESI
             jmp   SHORT lpef_exit
lpef_cnt2:
             mov   [ESI],EAX
             add   ESI,4
             add   EBX,4
             jmp   lpef_next_function
lpef_end_of_functions:
             pop   ESI
             add   ESI,20
             jmp   lpef_next_module
lpef_end_of_imports:
             pop   EDI

                   ; apply page protection

             movzx ECX,WORD PTR [EDI+2]     ; number of sections
             lea   EAX,[EDI+20+224]    ; first section header
             push  EDI
lpef_protect_section:
             push  EAX
             push  EBX
             push  ECX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination address
             push  ECX                 ; reserve address on stack for temp var
             mov   EDX,ESP             ; address of temp variable
             push  EDX
             mov   EDX,[EAX+36]        ; characteristics of section
             test  EDX,20000000h       ; test for executable section
             mov   EDX,20h             ;  set execute_read access for this case
             jnz   SHORT lpef_cnt3
             mov   EDX,40h             ;  otherwise set execute_read_write
lpef_cnt3:
             push  EDX
             push  ECX                 ; size of region
             push  EDI                 ; address of region
             call  _imp_GetCurrentProcess
             push  EAX
             call  _imp_VirtualProtectEx
             pop   ECX                 ; dispose temp variable
             pop   ECX
             pop   EBX
             pop   EAX
             add   EAX,40
             loop  lpef_protect_section
             pop   EDI

                   ; return address of entry point

             mov   EAX,[EDI+20+16]
             add   EAX,EBP
             jmp   SHORT lpef_exit
lpef_error:
             xor   EAX,EAX
lpef_exit:
             pop   EBP
             pop   EDI
             pop   ESI
             pop   EBX
             pop   ECX
             pop   EDX
             ret
LoadPEFile   ENDP

;
; GetEntryPoint: returns address of entry point of current process
; IN:  none
; OUT: EBX - address of entry point
;
GetEntryPoint  PROC
               push  EAX
               push  EDX
               push  ECX
               push  0
               call  _imp_GetModuleHandleA
               mov   EBX,EAX
               add   EBX,[EBX+60]
               add   EAX,[EBX+4+20+16]
               mov   EBX,EAX
               pop   ECX
               pop   EDX
               pop   EAX
               ret
GetEntryPoint  ENDP


;
; GetPEheader: returns offset of the portable executable file header
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - offset of the header or 0 if file hasn't PE header
;
GetPEheader  PROC
             push  EDX
             push  EBX
             cmp   ECX,64                ; check data size
             jna   SHORT gpeh_error
             cmp   WORD PTR [EAX], 5A4Dh ; check DOS header signature
             jnz   SHORT gpeh_error
             cmp   WORD PTR [EAX+8], 4   ; check DOS header size in paragraphs
             jb    SHORT gpeh_error
             mov   EBX,[EAX+60]          ; get offset of new exe header
             lea   EDX,[EBX+4+20+224]    ; required minimal size (0 sections)
             cmp   ECX,EDX               ; check data size
             jna   SHORT gpeh_error
             cmp   DWORD PTR [EBX+EAX], 4550h  ; check PE signature
             jnz   SHORT gpeh_error
             lea   EAX,[EBX+4]           ; PE header follows the signature
             jmp   SHORT gpeh_exit
gpeh_error:
             xor   EAX,EAX
gpeh_exit:
             pop   EBX
             pop   EDX
             ret
GetPEheader  ENDP

;
; CheckPEheader: check the portable executable file header
; IN:  EAX - pointer to the header
; OUT: CF=0 - ok, CF=1 - error
;
CheckPEheader PROC
             push  EDX
             cmp   WORD PTR [EAX], 14Ch  ; check machine type
             jnz   SHORT cpeh_error
             cmp   WORD PTR [EAX+16], 0E0h   ; check size of optional header
             jnz   SHORT cpeh_error
             mov   DX,[EAX+18]         ; check characteristics
             test  DH,20h              ; ! DLL?
             jnz   SHORT cpeh_error
             movzx EDX,WORD PTR [EAX+2]
             or    EDX,EDX             ; check number of sections
             jz    SHORT cpeh_error
             clc
             jmp   SHORT cpeh_exit
cpeh_error:
             stc
cpeh_exit:
             pop   EDX
             ret
CheckPEheader ENDP

;
; CheckOptHeader: check optional header and size of file data
; IN:  EBX - pointer to the file data
;      EDI - offset of PE header
;      ECX - size of file data
; OUT: CF=0 - ok, CF=1 - error
;
CheckOptHeader PROC
             push  EAX
             push  EDX
             push  ECX
             push  ESI
             push  EBP
             mov   EBP,ECX               ; preserve size
             movzx ECX,WORD PTR [EBX+EDI+2]    ; get number of sections
             mov   EAX,40                ; size of section
             mul   ECX
             cmp   EBP,EAX               ; check size of file data
             jna   SHORT coh_error
             lea   ESI,[EBX+EDI+20+224]  ; pointer to the first section header
coh_calc_total:
             mov   EAX,[ESI+16]          ; raw data size
             add   EAX,[ESI+20]          ; pointer to the raw data
             cmp   EBP,EAX               ; check size of file data
             jb    SHORT coh_error
             add   ESI,40
             loop  coh_calc_total        ; check all sections
             clc
             jmp   SHORT coh_exit
coh_error:
             stc
coh_exit:
             pop   EBP
             pop   ESI
             pop   ECX
             pop   EDX
             pop   EAX
             ret
CheckOptHeader ENDP

;
; CheckWinSock: since LoadLibrary and GetModuleHandle cause access violation
;               with wsock32.dll, we handle references to that separately;
;               this function check for wsock32 and if it is then resolves
;               references from this process's idata section
; IN:  EAX - module name address
;      ESI - import directory entry address
;      EDI - PE header address
;      EBP - image base address
; OUT: CF = 1 - handled, CF = 0 - not handled
;
CheckWinSock PROC
             pushad
             call  CmpWinSock          ; check for wsock32.dll
             jnc   cws_exit

                   ; yes, wsock32.dll

             push  0
             call  _imp_GetModuleHandleA
             mov   ECX,4096
             mov   EBX,EAX             ; EBX - our base address
             call  GetPEheader         ; get our PE header
             or    EAX,EAX
             jnz   SHORT cws_cnt1
cws_access_violation:
             mov   EAX,0FFFFFFFFh      ; raise
             jmp   EAX
cws_cnt1:
             mov   EDX,[EBX+EAX+20+96+8]   ; get import directory virt.addr.
cws_next_module:
             mov   EAX,[EBX+EDX+12]        ; module name address
             or    EAX,EAX
             jz    SHORT cws_access_violation  ; our wsock32 imports not found
             add   EAX,EBX
             call  CmpWinSock          ; check for wsock32.dll
             jc    SHORT cws_cnt2
             add   EDX,20
             jmp   cws_next_module
cws_cnt2:
                   ; for each relocation entry in dest table [ESI]
                   ;   find matching relocation entry in our table [EBX+EDX]
                   ;   and set address

             mov   EDI,[ESI]           ; EDI - function name list (dest)
             add   EDI,EBP
             mov   ESI,[ESI+16]        ; ESI - function address list (dest)
             add   ESI,EBP
cws_next_function:
             mov   EAX,[EDI]
             or    EAX,EAX
             jz    SHORT cws_end_of_functions
             push  EDI
             mov   EDI,[EBX+EDX]       ; EDI - function name list (ours)
             add   EDI,EBX
             push  EBX
             xor   EBX,EBX             ; offset of the entry
cws_cmp_next:
             mov   ECX,[EDI]
             add   EDI,4
             add   EBX,4
             or    ECX,ECX
             jz    cws_access_violation    ; entry not found
             cmp   ECX,EAX
             jnz   cws_cmp_next
                                       ; entry found - set address
             lea   ECX,[EBX-4]         ; ECX - offset in the list
             pop   EBX
             add   ECX,[EBX+EDX+16]
             add   ECX,EBX
             mov   EAX,[ECX]           ; get address
             mov   [ESI],EAX           ; and set
             pop   EDI
             add   ESI,4
             add   EDI,4
             jmp   cws_next_function
cws_end_of_functions:
             stc
             jmp   SHORT cws_exit
cws_failed:
             clc
cws_exit:
             popad
             ret
CheckWinSock ENDP

;
; CmpWinSock: compares string with wsock32.dll
; IN:  EAX - string address
; OUT: CF = 1 - compare ok, CF = 0 - failed
;
CmpWinSock   PROC
             pushad
             sub   ESP,12              ; reserve space on the stack
             mov   DWORD PTR [ESP],'cosw'
             mov   DWORD PTR [ESP+4],'.23k'
             mov   DWORD PTR [ESP+8],'lld'  ; init string
             mov   EDX,ESP
             push  EDX
             push  EAX
             call  _imp_lstrcmpi
             add   ESP,12              ; dispose space
             sub   EAX,1               ; set CF if EAX == 0
             popad
             ret
CmpWinSock   ENDP

ALIGN 16     ; padding

Code_End     LABEL NEAR

_TEXT        ENDS

             END
